<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Content extends Model 
{

    protected $table = 'content';
    public $timestamps = true;
    protected $fillable = array('node_id', 'mode', 'name');

    public function node()
    {
        return $this->belongsTo('App\Models\Node');
    }

    public function contentScheduledItems()
    {
        return $this->hasMany('App\Models\ContentScheduledItem');
    }

    public function contentSimpleItems()
    {
        return $this->hasMany('App\Models\ContentSimpleItem');
    }

    public function contentUpdateAudios()
    {
        return $this->hasMany('App\Models\ContentUpdate', 'audio_content_id');
    }

    public function contentUpdateVideos()
    {
        return $this->hasMany('App\Models\ContentUpdate', 'video_content_id');
    }

}